<?php
class Wpg_WpgOnPage_RedirectController extends Mage_Core_Controller_Front_Action
{
    private $url = false;

    public function indexAction(){
        $iframe = false;

        /** @var Wpg_WpgOnPage_Model_WpgOnPage */
        $payment = Mage::getModel('WpgOnPage/WpgOnPage');

         /** @var Wpg_WpgOnPage_Model_Gateway */
        $gateway = Mage::getModel('WpgOnPage/Gateway');
        
        $order = $payment->getQuote();
        if (!is_null($order->getIncrementId())) {
            $state = $gateway->getConfigData('order_status');
            $order->setStatus($state);
            $order->save();


            $this->url = $gateway->getRedirectUrl($order);
        }

        if ($this->url) {
            if ($iframe == true) {

                $this->loadLayout();
        
                $this->getLayout()->getBlock('content')->append(
                    $this->getLayout()->createBlock('WpgOnPage/iframe', '', ['url' => $this->url])
                );
                $this->getLayout()->getBlock('head')->setTitle($this->__('Order paymnet'));
                $this->renderLayout();

                // $this->getResponse()
                // ->setHeader('Content-type', 'text/html; charset=utf8')
                // ->setBody($this->getLayout()
                // ->createBlock('WpgOnPage/iframe')
                // ->toHtml());
            }else{
                $this->getResponse()->setRedirect($this->url);
            }
        }else{
            $this->getResponse()->setRedirect('/');
        }

        


    }

    public function getIframeUrl(){
        return $this->url;
    }


}