<?php

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

final class WC_Web_Payment_Gateway_Blocks_Support extends AbstractPaymentMethodType
{

    protected $name = 'wpgfull';
    protected $icon = false;

    public function initialize()
    {
        $this->settings = get_option( 'woocommerce_wpgfull_settings', [] );
    }


    public function is_active()
    {
        //var_dump($this->settings['enabled']);
        if ('yes' == $this->settings['enabled']) {
            return true;
        }
        return false;
    }

    public function get_payment_method_script_handles() {

        $src = WC_WPG_PLUGIN_DIR . 'js/checkout.js';

		wp_register_script( 'wc-payment-method-wpg', $src, [], false, true );

        //var_dump('init script');

		return [ 'wc-payment-method-wpg' ];
	}

    public function get_payment_method_data() {

        if (empty($this->get_setting( 'icon' ))) {
            // Load plugin checkout default icon
            $this->icon = WC_WPG_PLUGIN_URL . '/images/default-logo.png';
        }

        
        if ($this->get_setting( 'display_icon' ) == 'yes') {
            $this->icon = false;
        }


		return [
			'title'       => $this->get_setting( 'title' ),
			'description' => $this->get_setting( 'description' ),
			'supports'    => $this->get_supported_features(),
            'display_icon' => $this->get_setting( 'display_icon' ),

            'icon' => $this->icon,
		];
	}
}