<?php

namespace WPG\Gateway\Model\Traits;

use Monolog\Handler\RotatingFileHandler;
use Monolog\Logger as MonologLogger;

/**
 * Trait for defining common variables and methods for all Payment Solutions
 * Trait OnlinePaymentMethod
 * @package WPG\Gateway\Model\Traits
 */
trait Logger
{

	/**
	 * Collected debug information
	 *
	 * @var array
	 */
	protected $_debugData = [];

	/**
	 * Create logger.
	 *
	 * @return \Monolog\Logger
	 */
	protected function _initLogger()
	{

 		$path = BP . '/var/log/wpg.log';

        $rotatingFileHandler = new RotatingFileHandler(
            $path,
            15
        );

		$logger = new MonologLogger('wpg');
		$logger->pushHandler($rotatingFileHandler);	
		return $logger;
	}

	/**
	 * Log debug data to file
	 *
	 * @return void
	 */
	protected function _writeDebugData()
	{
		if ($this->getConfigHelper()->getDebug()) {
			$this->getLogger()->debug(var_export($this->_debugData, true));
		}
	}

	/**
	 * @param string $key
	 * @param array|string $value
	 * @return $this
	 */
	protected function _addDebugData($key, $value)
	{
		$this->_debugData[$key] = $value;
		return $this;
	}
}
